<?php

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'STDF_Hooks' ) ) {
	class STDF_Hooks {

		protected static $_instance = null;
		public $success = '';

		function __construct() {
			// ... [all your previous hooks as before]
			// No change needed here
			// All existing hooks remain
			add_filter( 'bulk_actions-edit-shop_order', array( $this, 'register_bulk_action_send_steadfast' ) );
			add_action( 'handle_bulk_actions-edit-shop_order', array( $this, 'send_to_steadfast_bulk_process' ), 20, 3 );
			add_filter( 'bulk_actions-woocommerce_page_wc-orders', array( $this, 'register_bulk_action_send_steadfast' ), 999 );
			add_action( 'handle_bulk_actions-woocommerce_page_wc-orders', array( $this, 'send_to_steadfast_bulk_process' ), 20, 3 );

			add_filter( 'manage_edit-shop_order_columns', array( $this, 'add_steadfast_custom_column' ) );
			add_action( 'manage_shop_order_posts_custom_column', array( $this, 'add_custom_column_content_order_list_table' ) );
			add_filter( 'woocommerce_shop_order_list_table_columns', array( $this, 'add_steadfast_custom_column' ) );
			add_action( 'woocommerce_shop_order_list_table_custom_column', array( $this, 'add_custom_column_content_order_page' ), 10, 2 );

			add_action( 'wp_ajax_api_ajax_call', array( $this, 'api_ajax_call' ) );
			add_action( 'wp_ajax_input_amount', array( $this, 'stdf_custom_amount_pay' ) );

			add_filter( 'post_class', array( $this, 'admin_orders_table_row_unlink' ), 10, 3 );
			add_filter( 'woocommerce_shop_order_list_table_order_css_classes', array( $this, '_admin_orders_table_row_unlink' ) );

			add_filter( 'plugin_action_links', array( $this, 'add_plugin_action_links' ), 10, 4 );
			add_action( 'init', array( $this, 'stdf_invoice_template' ) );
			add_action( 'admin_menu', array( $this, 'stdf_add_invoice_template_page' ) );
		}

		// ... [all other functions as before]

		/**
		 * Send Data To SteadFast Api.
		 *
		 * @param $order_id
		 *
		 * @return string
		 */
		function call_steadfast_api( $order_id ): string {
			global $wpdb;

			$checkbox       = get_option( 'stdf_settings_tab_checkbox', false );
			$api_secret_key = get_option( 'api_settings_tab_api_secret_key', false );
			$api_key        = get_option( 'api_settings_tab_api_key', false );
			$api_notes      = get_option( 'stdf_settings_tab_notes', false );

			$order      = new WC_Order( $order_id );
			$order_data = $order->get_data();

			$input_amount = get_post_meta( $order_id, 'steadfast_amount', true );
			$input_amount = ! empty( $input_amount ) || $input_amount == 0 ? $input_amount : $order_data['total'];

			$fast_name               = $order_data['billing']['first_name'];
			$last_name               = $order_data['billing']['last_name'];
			$order_billing_address   = $order_data['billing']['address_1'];
			$order_billing_phone     = $order_data['billing']['phone'];
			$order_shipping_city     = $order_data['billing']['city'];
			$order_shipping_postcode = $order_data['billing']['postcode'];

			$order_note = $api_notes == 'yes' ? $order->get_customer_note() : '';

			$n              = 10;
			$number         = strlen( $order_billing_phone ) - $n;
			$phone          = substr( $order_billing_phone, $number );
			$customer_phone = '0' . $phone;

			$recipient_address = $order_billing_address . ',' . $order_shipping_city . '-' . $order_shipping_postcode;
			$body              = array(
				"invoice"           => gmdate( "ymj" ) . '-' . $order_id,
				"recipient_name"    => $fast_name . ' ' . $last_name,
				"recipient_phone"   => $customer_phone,
				"recipient_address" => $recipient_address,
				"cod_amount"        => $input_amount,
				"note"              => $order_note,
			);

			$args = array(
				'method'      => 'POST',
				'headers'     => array(
					'content-type' => 'application/json',
					'api-key'      => sanitize_text_field( $api_key ),
					'secret-key'   => sanitize_text_field( $api_secret_key ),
				),
				'timeout'     => 45,
				'redirection' => 5,
				'httpversion' => '1.0',
				'body'        => wp_json_encode( $body ),
				'cookies'     => array()
			);

			if ( $checkbox == 'yes' ) {
				$response = wp_remote_post( 'https://portal.packzy.com/api/v1/create_order', $args );
				$request = json_decode( wp_remote_retrieve_body( $response ), true );

				// === SHIPMENTS TABLE INSERT HERE ===
				// Get values for DB
				$status = isset($request['status']) ? $request['status'] : 'failed';
				$consignment_id = isset($request['consignment']['consignment_id']) ? $request['consignment']['consignment_id'] : '';
				$tracking_number = isset($request['consignment']['tracking_number']) ? $request['consignment']['tracking_number'] : '';
				$pickup_requested_at = isset($request['consignment']['pickup_requested_at']) ? $request['consignment']['pickup_requested_at'] : '';
				$last_update = current_time('mysql');
				$created_at = current_time('mysql');

				// Insert into shipments table (change table prefix if needed)
				$wpdb->insert(
					$wpdb->prefix . 'shipments',
					array(
						'order_id'          => $order_id,
						'courier_name'      => 'SteadFast',
						'courier_order_id'  => $consignment_id,
						'tracking_number'   => $tracking_number,
						'status'            => $status,
						'pickup_requested_at'=> $pickup_requested_at,
						'last_update'       => $last_update,
						'request_payload'   => wp_json_encode($body),
						'response_payload'  => wp_json_encode($request),
						'created_at'        => $created_at,
					),
					array('%d','%s','%s','%s','%s','%s','%s','%s','%s','%s')
				);

				// Old meta update (for backward compatibility)
				if ( isset( $request['status'] ) && $request['status'] == 400 && isset( $request['errors'] ) ) {
					$errors = $request['errors'];
					foreach ( $errors as $field => $messages ) {
						foreach ( $messages as $message ) {
							return $message;
						}
					}
				}

				if ( $request['status'] == 200 ) {
					update_post_meta( $order_id, 'steadfast_consignment_id', $consignment_id );
					return esc_html__( 'success', 'steadfast-api' );
				}
			}

			return esc_html__( 'unauthorized', 'steadfast-api' );
		}

		// ... [other functions unchanged]

		public static function instance() {
			if ( is_null( self::$_instance ) ) {
				self::$_instance = new self();
			}
			return self::$_instance;
		}
	}
}

STDF_Hooks::instance();